/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures;

public class BitSet {
    private int val;

    public BitSet() {
        this.val = 0;
    }

    public BitSet(String s) {
        this.val = new Integer(s);
    }

    private BitSet(int i) {
        this.val = i;
    }

    public void setBit(int index, boolean b) {
        if (index >= 32) {
            throw new Error("Does not support more than 32 bits!");
        }
        int mask = 1 << index;
        if (b) {
            this.val |= mask;
            return;
        }
        this.val -= mask;
    }

    public boolean getBit(int index) {
        return (this.val & 1 << index) != 0;
    }

    public String toString() {
        return String.valueOf(this.val);
    }

    public int hashCode() {
        return this.val;
    }

    public int toInt() {
        return this.val;
    }

    public BitSet AND(BitSet other) {
        return new BitSet(this.val & other.val);
    }

    public boolean equals(Object o) {
        if (o instanceof Integer) {
            return this.val == (Integer)o;
        }
        if (o instanceof BitSet) {
            return this.val == ((BitSet)o).val;
        }
        return false;
    }
}

